/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions.utility;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.utility.ShowCardAction;
import com.megacrit.cardcrawl.actions.utility.WaitAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.unlock.UnlockTracker;

public class UseCardAction
extends AbstractGameAction {
    private AbstractCard targetCard;
    public AbstractCreature target = null;
    public boolean exhaustCard;
    private static final float DUR = 0.15f;

    public UseCardAction(AbstractCard card, AbstractCreature target) {
        this.targetCard = card;
        this.target = target;
        if (card.exhaustOnUseOnce || card.exhaust) {
            this.exhaustCard = true;
        }
        this.setValues(AbstractDungeon.player, null, 1);
        this.duration = 0.15f;
        for (AbstractPower p : AbstractDungeon.player.powers) {
            if (card.dontTriggerOnUseCard) continue;
            p.onUseCard(card, this);
        }
        for (AbstractRelic r : AbstractDungeon.player.relics) {
            if (card.dontTriggerOnUseCard) continue;
            r.onUseCard(card, this);
        }
        for (AbstractMonster m : AbstractDungeon.getCurrRoom().monsters.monsters) {
            for (AbstractPower p : m.powers) {
                if (card.dontTriggerOnUseCard) continue;
                p.onUseCard(card, this);
            }
        }
        this.actionType = this.exhaustCard ? AbstractGameAction.ActionType.EXHAUST : AbstractGameAction.ActionType.USE;
    }

    public UseCardAction(AbstractCard targetCard) {
        this(targetCard, null);
    }

    @Override
    public void update() {
        if (this.duration == 0.15f) {
            for (AbstractPower p : AbstractDungeon.player.powers) {
                if (this.targetCard.dontTriggerOnUseCard) continue;
                p.onAfterUseCard(this.targetCard, this);
            }
            if (this.target != null) {
                for (AbstractPower p : this.target.powers) {
                    if (this.targetCard.dontTriggerOnUseCard) continue;
                    p.onAfterUseCard(this.targetCard, this);
                }
            } else if (this.target == null) {
                for (AbstractMonster m : AbstractDungeon.getMonsters().monsters) {
                    for (AbstractPower p : m.powers) {
                        if (this.targetCard.dontTriggerOnUseCard) continue;
                        p.onAfterUseCard(this.targetCard, this);
                    }
                }
            }
            this.targetCard.freeToPlayOnce = false;
            if (this.targetCard.purgeOnUse) {
                AbstractDungeon.actionManager.addToTop(new ShowCardAction(this.targetCard));
                this.isDone = true;
                AbstractDungeon.player.cardInUse = null;
                return;
            }
            if (this.targetCard.type == AbstractCard.CardType.POWER) {
                AbstractDungeon.actionManager.addToTop(new ShowCardAction(this.targetCard));
                if (CardCrawlGame.fastMode) {
                    AbstractDungeon.actionManager.addToTop(new WaitAction(0.2f));
                } else {
                    AbstractDungeon.actionManager.addToTop(new WaitAction(0.7f));
                }
                AbstractDungeon.player.hand.empower(this.targetCard);
                this.isDone = true;
                AbstractDungeon.player.hand.applyPowers();
                AbstractDungeon.player.hand.glowCheck();
                AbstractDungeon.player.cardInUse = null;
                if (AbstractDungeon.player.hand.size() + AbstractDungeon.player.drawPile.size() + AbstractDungeon.player.discardPile.size() <= 3) {
                    UnlockTracker.unlockAchievement("PURITY");
                }
                return;
            }
            AbstractDungeon.player.cardInUse = null;
            if (!this.exhaustCard) {
                AbstractDungeon.player.hand.moveToDiscardPile(this.targetCard);
            } else {
                this.targetCard.exhaustOnUseOnce = false;
                if (AbstractDungeon.player.hasRelic("Strange Spoon") && this.targetCard.type != AbstractCard.CardType.POWER) {
                    if (MathUtils.randomBoolean()) {
                        AbstractDungeon.player.getRelic("Strange Spoon").flash();
                        AbstractDungeon.player.hand.moveToDiscardPile(this.targetCard);
                    } else {
                        AbstractDungeon.player.hand.moveToExhaustPile(this.targetCard);
                        CardCrawlGame.dungeon.checkForPurityAndPactAchievement();
                    }
                } else {
                    AbstractDungeon.player.hand.moveToExhaustPile(this.targetCard);
                    CardCrawlGame.dungeon.checkForPurityAndPactAchievement();
                }
            }
        }
        this.tickDuration();
    }
}

